using System;

namespace Team_Project
{
	/// <summary>
	/// Interfaccia che deve implementare chi desidera gestire un messaggio TCP
	/// utilizzando l'helper.
	/// </summary>
 	/// <remarks>
	/// <para>La classe che implementa questa interfaccia deve necessariamente
	/// avere anche un costruttore con la seguente signature:
	/// <code>public MyClass(string mess,Socket skt,NetworkStream str)</code>
	/// o compatibile.</para>
	/// <para>Il primo parametro rappresenta il tipo di messaggio ricevuto e pu
	/// essere utilizzato nel caso la classe sia registrata come gestore di pi
	/// di un tipo di messaggio.</para>
	/// <para>Il secondo parametro  la socket di connessione. E' necessario 
	/// effettuare lo shutdown e la close prima di terminare il gestore.</para>
	/// <para>Il terzo parametro  lo stream in lettura-scrittura associato
	/// alla socket. Generalmente i messaggi sono inviati in modalit fire&amp;forget
	/// e quindi la scrittura su tale stream  sconsigliata.</para>
	/// </remarks>
	public interface IMessageHandler
	{
		/// <summary>
		/// Metodo invocato dal listener per far partire la gestione del messaggio
		/// </summary>
		void Go();
	}
}
